<!DOCTYPE html>
<html lang="zxx">
<head>
	<!-- Meta -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="description" content="">
	<meta name="keywords" content="">
	<meta name="author" content="">
	<!-- Page Title -->
    <title>Dr. Santosh Mane</title>
	<!-- Favicon Icon -->
	<link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
	<!-- Google Fonts Css-->
	<link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&amp;display=swap" rel="stylesheet">
    
    <!-- Bootstrap Css -->
	<link href="css/bootstrap.min.css" rel="stylesheet" media="screen">
	<!-- SlickNav Css -->
	<link href="css/slicknav.min.css" rel="stylesheet">
	<!-- Swiper Css -->
	<link rel="stylesheet" href="css/swiper-bundle.min.css">
	<!-- Font Awesome Icon Css-->
	<link href="css/all.css" rel="stylesheet" media="screen">
	<!-- Animated Css -->
	<link href="css/animate.css" rel="stylesheet">
	<!-- Magnific Popup Core Css File -->
	<link rel="stylesheet" href="css/magnific-popup.css">
    <!-- Image Comparision Css File -->
	<link rel="stylesheet" href="css/twentytwenty.css">
	<!-- Mouse Cursor Css File -->
	<link rel="stylesheet" href="css/mousecursor.css">
	<!-- Main Custom Css -->
	<link href="css/custom.css" rel="stylesheet" media="screen">
</head>

<body>

  <!-- Header Start -->
	<?php include 'header.php';?>
  <!-- Header End -->

    <!-- Hero Section Start -->
	<div class="hero bg-image">
		<div class="hero-section hero-video">
            <!-- Video Start -->
            <div class="hero-bg-video">
                <!-- Selfhosted Video Start -->
                <!-- <video autoplay muted loop id="myVideo"><source src="images/hero-bg-video.mp4" type="video/mp4"></video> -->
                <video autoplay muted loop id="myVideo"><source src="images/child-video.mp4" type="video/mp4"></video>
                
                <!-- Selfhosted Video End -->

                <!-- Youtube Video Start -->
                <!-- <div id="herovideo" class="player" data-property="{videoURL:'74DWwSxsVSs',containment:'.hero-video', showControls:false, autoPlay:true, loop:true, vol:0, mute:false, startAt:0,  stopAt:296, opacity:1, addRaster:true, quality:'large', optimizeDisplay:true}"></div> -->
                <!-- Youtube Video End -->
            </div>
            <!-- Video End -->
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-12">
                        <!-- Hero Content Start -->
                        <div class="hero-content">
                            <!-- Section Title Start -->
                            <div class="section-title">
                                <h1 data-cursor="-opaque">Caring for The <br> Happy Little Giggles</h1>
                                <!-- <p class="wow fadeInUp" data-wow-delay="0.25s">Experience top-quality dental care focused on your smile's health and beauty. Trust us to create a brighter, healthier tomorrow.</p> -->
                            </div>
                            <!-- Section Title End -->
    
                            <!-- Hero Content Footer Start -->
                            <div class="hero-content-footer wow fadeInUp" data-wow-delay="0.5s">
                                <a href="tel:9922446723" class="btn-default">book now</a>
                                <a href="contact-us.php" class="btn-default btn-highlighted">enquiries</a>
                            </div>
                            <!-- Hero Content Footer End -->
                        </div>
                        <!-- Hero Content End -->                    
                    </div>
                </div>
            </div>
        </div>

        <!-- Our Cta Box Start -->
        <div class="our-cta-box">
            <div class="container">
                <!-- Cta Content Box Start -->
                <div class="row cta-content-box">
                    <div class="col-lg-4 col-md-6">
                        <!-- Cta Item Start -->
                        <div class="cta-item wow fadeInUp">
                            <div class="icon-box">
                                <img src="images/icon-phone.svg" alt="">
                            </div>
                            <div class="cta-item-content">
                                <h3>Need Pediatric Services ?</h3>
                                <p>+91 9922446723</p>
                            </div>
                        </div>
                        <!-- Cta Item End -->                    
                    </div>

                    <div class="col-lg-4 col-md-6">
                        <!-- Cta Item Start -->
                        <div class="cta-item wow fadeInUp" data-wow-delay="0.25s">
                            <div class="icon-box">
                                <img src="images/icon-watch.svg" alt="">
                            </div>
                            <div class="cta-item-content">
                                <h3>Opening Hours</h3>
                                <p>Mon to Sat 10:00AM to 1:00PM </p>
                                <p>Mon to Sat 6:00PM to 9:00PM</p>
                            </div>
                        </div>
                        <!-- Cta Item End -->                    
                    </div>

                    <div class="col-lg-4 col-md-12">
                          <div class="cta-btn wow fadeInUp" data-wow-delay="0.5s">
                            <a href="contact-us.php" class="btn-default">Make An Appoinment</a>
                          </div>            
                    </div>
                </div>
                <!-- Cta Content Box End -->
            </div>
        </div>
        <!-- Our Cta Box End -->
    </div>
    <!-- Hero Section End -->

    <!-- About Us Section Start -->
    <div class="about-us" id="about">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 order-lg-1 order-2">
                    <!-- About Us Image Start -->
                    <div class="about-image">
                        <!-- About Image Start -->
                        <div class="about-img">
                            <figure class="image-anime">
                                <img src="images/dr-santosh-mane.jpeg" alt="">
                            </figure>
                        </div>
                        <!-- About Image End -->

                        <!-- Company Experience Start -->
                        <div class="company-experience">
                            <div class="company-experience-box">
                                <div class="company-experience-counter">
                                    <h2><span class="counter">7</span>+</h2>
                                </div>
                                <div class="company-experience-content">
                                    <p>Experience in Pediatrician</p>
                                </div>
                            </div>                            
                        </div>
                        <!-- Company Experience End -->
                    </div>
                    <!-- About Us Image End -->
                </div>

                <div class="col-lg-6 order-lg-2 order-1">
                    <!-- About Us Content Start -->
                    <div class="about-us-content">
                        <!-- Section Title Start -->
                        <div class="section-title">
                            <h3 class="wow fadeInUp">About Us</h3>
                            <h2 class="" data-cursor="">
                             Dr. Santosh Mane
                            </h2>
                            <p class="wow fadeInUp" data-wow-delay="0.25s">
                              Dr. Santosh Mane is a highly skilled and compassionate Consultant Pediatrician and Neonatologist, dedicated to providing exceptional care for newborns, infants, and children. With an M.B.B.S., D.C.H., and PGPN (Boston University), Dr. Mane brings a wealth of medical expertise and a deep understanding of child health and development. His extensive training and clinical experience enable him to manage a wide range of pediatric conditions — from routine checkups and immunizations to complex neonatal and pediatric care — with precision and empathy.
                            </p>
                            <p class="wow fadeInUp" data-wow-delay="0.25s">
                             Driven by a passion for child wellness, Dr. Mane believes in a holistic approach that combines advanced medical knowledge with genuine care for every young patient. He is committed to guiding parents through every stage of their child’s growth, ensuring their physical, emotional, and developmental well-being. With his approachable nature and evidence-based medical practice, Dr. Mane has earned the trust of countless families who value his dedication, expertise, and warmth in caring for their children.
                            </p>
                        </div>
                        <!-- Section Title End -->

                        <!-- About Us Body Start -->
                        <div class="about-us-body wow fadeInUp" data-wow-delay="0.5s">
                            <!-- About Body Item Start -->
                            <div class="about-body-item">
                                <div class="about-counter">
                                    <h2><span class="counter">98</span>%</h2>
                                </div>
                                <div class="about-counter-content">
                                    <p>Children's Health Initiative</p>
                                </div>
                            </div>
                            <!-- About Body Item End -->

                            <!-- About Body Item Start -->
                            <div class="about-body-item">
                                <div class="about-counter">
                                    <h2><span class="counter">100</span>%</h2>
                                </div>
                                <div class="about-counter-content">
                                    <p>patient satisfaction rate</p>
                                </div>
                            </div>
                            <!-- About Body Item End -->
                        </div>
                        <!-- About Us Body End -->

                        <!-- About Us Footer Start -->
                        <div class="about-us-footer wow fadeInUp" data-wow-delay="0.75s">
                          <!-- About Company Founder Start -->
                            <div class="about-company-founder">
                               
                            </div>
                            <!-- About Company Founder End -->                            
                        </div>
                        <!-- About Us Footer End -->
                    </div>
                    <!-- About Us Content End -->
                </div>
            </div>
        </div>
    </div>
    <!-- About Us Section End -->

    <!-- Our Services Section Start -->
    <div class="our-service" id="services">
        <div class="container">
            <div class="row section-row align-items-center">
                <div class="col-lg-8">
                    <!-- Section Title Start -->
                    <div class="section-title">
                        <h3 class="wow fadeInUp">Our Services</h3>
                        <h2 class="text-anime-style-3" data-cursor="-opaque">
                         Comprehensive child care services for every little life.
                        </h2>
                    </div>
                    <!-- Section Title End -->
                </div>

                <div class="col-lg-4">
                  
                </div>
            </div>

            <div class="row">
			
			    <div class="col-lg-4 col-md-6">
                    <!-- Service Item Start -->
                    <div class="service-item wow fadeInUp" >
                        <!-- Service Header Start -->
                        <div class="service-header">
                            <!-- Service Item Box Start -->
                            <div class="service-item-box">
                                <div class="icon-box">
                                    <img src="images/icon-service-6.svg" alt="">
                                </div>
                                <div class="service-item-content">
                                    <h3>center for best quality vaccines</h3>
                                </div>
                            </div>
                            <!-- Service Item Box End -->

                            <!-- Service Readmore Start -->
                            <div class="service-readmore">
                                <a href="center-for-best-quality-vaccines.php"><img src="images/arrow-accent.svg" alt=""></a>
                            </div>
                            <!-- Service Readmore End -->
                        </div>
                        <!-- Service Header End -->

                        <!-- Service Body Start -->
                        <div class="service-body">
                            <p>
                                In your child's case, nothing is as essential as their safe and timely vaccination. 
                                Dr. Mane's Child Care Clinic
                            </p>
                        </div>
                        <!-- Service Body End -->

                        <!-- Service Image Start -->
                        <div class="service-image">
                            <a href="center-for-best-quality-vaccines.php">
                                <figure class="image-anime">
                                    <img src="images/service/vaccination.jpg" alt="">
                                </figure>
                            </a>
                        </div>
                        <!-- Service Image End -->
                    </div>
                    <!-- Service Item End -->
                </div>
				
				<div class="col-lg-4 col-md-6">
                    <!-- Service Item Start -->
                    <div class="service-item wow fadeInUp" data-wow-delay="0.2s">
                        <!-- Service Header Start -->
                        <div class="service-header">
                            <!-- Service Item Box Start -->
                            <div class="service-item-box">
                                <div class="icon-box">
                                    <img src="images/vaccination-icon.png" alt="">
                                </div>
                                <div class="service-item-content">
                                    <h3>Needle-free Vaccinations</h3>
                                </div>
                            </div>
                            <!-- Service Item Box End -->

                            <!-- Service Readmore Start -->
                            <div class="service-readmore">
                                <a href="needle-free-vaccinations.php"><img src="images/arrow-accent.svg" alt=""></a>
                            </div>
                            <!-- Service Readmore End -->
                        </div>
                        <!-- Service Header End -->

                        <!-- Service Body Start -->
                        <div class="service-body">
                          <p> 
                            Dr. Mane Child Care Clinic is aware that most children fear needles. This is why we have needle-free vaccination, 
                         </p>
                        </div>
                        <!-- Service Body End -->

                        <!-- Service Image Start -->
                        <div class="service-image">
                            <a href="needle-free-vaccinations.php">
                                <figure class="image-anime">
                                    <img src="images/service/needle.webp" alt="">
                                </figure>
                            </a>
                        </div>
                        <!-- Service Image End -->
                    </div>
                    <!-- Service Item End -->
                </div>
				
				
                <div class="col-lg-4 col-md-6">
                    <!-- Service Item Start -->
                    <div class="service-item wow fadeInUp" data-wow-delay="0.4s">
                        <!-- Service Header Start -->
                        <div class="service-header">
                            <!-- Service Item Box Start -->
                            <div class="service-item-box">
                                <div class="icon-box">
                                    <img src="images/breastfeeding.png" alt="">
                                </div>
                                <div class="service-item-content">
                                    <h3>Breastfeeding Counseling</h3>
                                </div>
                            </div>
                            <!-- Service Item Box End -->

                            <!-- Service Readmore Start -->
                            <div class="service-readmore">
                                <a href="breastfeeding-counseling.php"><img src="images/arrow-accent.svg" alt=""></a>
                            </div>
                            <!-- Service Readmore End -->
                        </div>
                        <!-- Service Header End -->

                        <!-- Service Body Start -->
                        <div class="service-body">
                            <p>
                              Dr. Mane, at the Child Care Clinic, appreciates that even though breastfeeding is natural.
                            </p>
                        </div>
                        <!-- Service Body End -->

                        <!-- Service Image Start -->
                        <div class="service-image">
                            <a href="breastfeeding-counseling.php">
                                <figure class="image-anime">
                                    <img src="images/service/breastfeeding.jpg" alt="">
                                </figure>
                            </a>
                        </div>
                        <!-- Service Image End -->
                    </div>
                    <!-- Service Item End -->
                </div>

                <div class="col-lg-4 col-md-6">
                    <!-- Service Item Start -->
                    <div class="service-item wow fadeInUp" data-wow-delay="0.6s">
                        <!-- Service Header Start -->
                        <div class="service-header">
                            <!-- Service Item Box Start -->
                            <div class="service-item-box">
                                <div class="icon-box">
                                    <img src="images/growth.png" alt="">
                                </div>
                                <div class="service-item-content">
                                    <h3>Growth and Development Evaluation and Counselling</h3>
                                </div>
                            </div>
                            <!-- Service Item Box End -->

                            <!-- Service Readmore Start -->
                            <div class="service-readmore">
                                <a href="growth-and-development-evaluation-and-counselling.php"><img src="images/arrow-accent.svg" alt=""></a>
                            </div>
                            <!-- Service Readmore End -->
                        </div>
                        <!-- Service Header End -->

                        <!-- Service Body Start -->
                        <div class="service-body">
                            <p>
                                Dr. Mane's Child Care Clinic believes that every child deserves the best start in their life. Our clinic, led by a senior paediatrician
                            </p>
                        </div>
                        <!-- Service Body End -->

                        <!-- Service Image Start -->
                        <div class="service-image">
                            <a href="growth-and-development-evaluation-and-counselling.php">
                                <figure class="image-anime">
                                    <img src="images/service/growth-and-development.jpg" alt="">
                                </figure>
                            </a>
                        </div>
                        <!-- Service Image End -->
                    </div>
                    <!-- Service Item End -->
                </div>

                <div class="col-lg-4 col-md-6">
                    <!-- Service Item Start -->
                    <div class="service-item wow fadeInUp" data-wow-delay="0.8s">
                        <!-- Service Header Start -->
                        <div class="service-header">
                            <!-- Service Item Box Start -->
                            <div class="service-item-box">
                                <div class="icon-box">
                                    <img src="images/nutritional.png" alt="">
                                </div>
                                <div class="service-item-content">
                                    <h3>Nutritional counselling for growing children</h3><br>
                                </div>
                            </div>
                            <!-- Service Item Box End -->

                            <!-- Service Readmore Start -->
                            <div class="service-readmore">
                                <a href="nutritional-counselling-for-growing-children.php"><img src="images/arrow-accent.svg" alt=""></a>
                            </div>
                            <!-- Service Readmore End -->
                        </div>
                        <!-- Service Header End -->

                        <!-- Service Body Start -->
                        <div class="service-body">
                            <p>
                               As a Child Care Clinic, we know that proper childhood development starts with proper nutrition.
                            </p>
                        </div>
                        <!-- Service Body End -->

                        <!-- Service Image Start -->
                        <div class="service-image">
                            <a href="nutritional-counselling-for-growing-children.php">
                                <figure class="image-anime">
                                    <img src="images/service/nutritional-counselling.jpg" alt="">
                                </figure>
                            </a>
                        </div>
                        <!-- Service Image End -->
                    </div>
                    <!-- Service Item End -->
                </div>

                <div class="col-lg-4 col-md-6">
                    <!-- Service Item Start -->
                    <div class="service-item wow fadeInUp" data-wow-delay="1.0s">
                        <!-- Service Header Start -->
                        <div class="service-header">
                            <!-- Service Item Box Start -->
                            <div class="service-item-box">
                                <div class="icon-box">
                                    <img src="images/allergy.png" alt="">
                                </div>
                                <div class="service-item-content">
                                    <h3>Pediatric <br> allergies and <br> their care</h3><br>
                                </div>
                            </div>
                            <!-- Service Item Box End -->

                            <!-- Service Readmore Start -->
                            <div class="service-readmore">
                                <a href="pediatric-allergies-and-their-care.php"><img src="images/arrow-accent.svg" alt=""></a>
                            </div>
                            <!-- Service Readmore End -->
                        </div>
                        <!-- Service Header End -->

                        <!-- Service Body Start -->
                        <div class="service-body">
                            <p>
                                At Dr. Mane Child Care Clinic, we are aware of how pediatric allergies can be so disturbing not only to the children
                            </p>
                        </div>
                        <!-- Service Body End -->

                        <!-- Service Image Start -->
                        <div class="service-image">
                            <a href="pediatric-allergies-and-their-care.php">
                                <figure class="image-anime">
                                    <img src="images/service/pediatric-allergies.jpg" alt="">
                                </figure>
                            </a>
                        </div>
                        <!-- Service Image End -->
                    </div>
                    <!-- Service Item End -->
                </div>

                <div class="col-lg-4 col-md-6">
                    <!-- Service Item Start -->
                    <div class="service-item wow fadeInUp" data-wow-delay="1.2s">
                        <!-- Service Header Start -->
                        <div class="service-header">
                            <!-- Service Item Box Start -->
                            <div class="service-item-box">
                                <div class="icon-box">
                                    <img src="images/newborn.png" alt="">
                                </div>
                                <div class="service-item-content">
                                    <h3>Newborn care and counselling</h3>
                                </div>
                            </div>
                            <!-- Service Item Box End -->

                            <!-- Service Readmore Start -->
                            <div class="service-readmore">
                                <a href="newborn-care-and-counselling.php"><img src="images/arrow-accent.svg" alt=""></a>
                            </div>
                            <!-- Service Readmore End -->
                        </div>
                        <!-- Service Header End -->

                        <!-- Service Body Start -->
                        <div class="service-body">
                            <p>Having a child is a great experience, and one of the concerns is to ensure that the baby is healthy ever since the first day.</p>
                        </div>
                        <!-- Service Body End -->

                        <!-- Service Image Start -->
                        <div class="service-image">
                            <a href="newborn-care-and-counselling.php">
                                <figure class="image-anime">
                                    <img src="images/service/newborn-care-and-counselling.jpg" alt="">
                                </figure>
                            </a>
                        </div>
                        <!-- Service Image End -->
                    </div>
                    <!-- Service Item End -->
                </div>
				
				<div class="col-lg-4 col-md-6">
                    <!-- Service Item Start -->
                    <div class="service-item wow fadeInUp" data-wow-delay="1.2s">
                        <!-- Service Header Start -->
                        <div class="service-header">
                            <!-- Service Item Box Start -->
                            <div class="service-item-box">
                                <div class="icon-box">
                                    <img src="images/icon-service-2.svg" alt="">
                                </div>
                                <div class="service-item-content">
                                    <h3>Online consultations for urgent concerns</h3>
                                </div>
                            </div>
                            <!-- Service Item Box End -->

                            <!-- Service Readmore Start -->
                            <div class="service-readmore">
                                <a href="online-consultations-for-urgent-concerns.php"><img src="images/arrow-accent.svg" alt=""></a>
                            </div>
                            <!-- Service Readmore End -->
                        </div>
                        <!-- Service Header End -->

                        <!-- Service Body Start -->
                        <div class="service-body">
                            <p>
                                You never know what parenting will bring you - those spots mark that seem to come out of nowhere, sky-scraping
                            </p>
                        </div>
                        <!-- Service Body End -->

                        <!-- Service Image Start -->
                        <div class="service-image">
                            <a href="online-consultations-for-urgent-concerns.php">
                                <figure class="image-anime">
                                    <img src="images/service/pediatrician.jpg" alt="">
                                </figure>
                            </a>
                        </div>
                        <!-- Service Image End -->
                    </div>
                    <!-- Service Item End -->
                </div>

                <div class="col-lg-4 col-md-6">
                    <!-- Service Item Start -->
                    <div class="service-item wow fadeInUp" data-wow-delay="1.2s">
                        <!-- Service Header Start -->
                        <div class="service-header">
                            <!-- Service Item Box Start -->
                            <div class="service-item-box">
                                <div class="icon-box">
                                    <img src="images/icon-service-2.svg" alt="">
                                </div>
                                <div class="service-item-content">
                                    <h3>Availability at 2 clinics</h3>
                                </div>
                            </div>
                            <!-- Service Item Box End -->

                            <!-- Service Readmore Start -->
                            <div class="service-readmore">
                                <a href="availability-at-2-clinics.php"><img src="images/arrow-accent.svg" alt=""></a>
                            </div>
                            <!-- Service Readmore End -->
                        </div>
                        <!-- Service Header End -->

                        <!-- Service Body Start -->
                        <div class="service-body">
                            <p> Evaluation and management of jaw pain, TMJ disorders, facial pain, musculoskeletal conditions affecting </p>
                        </div>
                        <!-- Service Body End -->

                        <!-- Service Image Start -->
                        <div class="service-image">
                            <a href="availability-at-2-clinics.php">
                                <figure class="image-anime">
                                    <img src="images/service/clinic.jpeg" alt="">
                                </figure>
                            </a>
                        </div>
                        <!-- Service Image End -->
                    </div>
                    <!-- Service Item End -->
                </div>

                
            </div>
        </div>
    </div>
    <!-- Our Services Section End -->

    

    <!-- Why Choose Us Section Start -->
    <div class="why-choose-us">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-4 order-lg-1 order-1">
                    <!-- Why Choose Content Start -->
                    <div class="why-choose-content">
                        <!-- Section Title Start -->
                        <div class="section-title">
                            <h3 class="wow fadeInUp">why choose us</h3>
                            <h2 class="text-anime-style-3" data-cursor="-opaque">Excellence results you can trust</h2>
                            <p class="wow fadeInUp" data-wow-delay="0.25s">
                             Accurate diagnosis of pediatric and neonatal conditions ensures effective treatment plans, 
                             helping to support healthy growth, development, and prevent future complications.
                            </p>
                        </div>
                        <!-- Section Title End -->

                        <!-- Why Choose Btn Start -->
                        <div class="why-choose-btn wow fadeInUp">
                            <a href="contact-us.php" class="btn-default btn-border">contact us</a>
                        </div>
                        <!-- Why Choose Btn End -->
                    </div>
                    <!-- Why Choose Content End -->
                </div>

                <div class="col-lg-4 order-lg-2 order-3">
                    <!-- Why Choose Image Start -->
                    <div class="why-choose-image">
                        <figure>
                            <img src="images/why-choose-image.png" alt="">
                        </figure>
                    </div>
                    <!-- Why Choose Image End -->
                </div>

                <div class="col-lg-4 order-lg-3 order-2">
                    <!-- Why Choose List Start -->
                    <div class="why-choose-list wow fadeInUp">
                        <!-- Why Choose Item Start -->
                        <div class="why-choose-item">
                            <div class="icon-box">
                                <img src="images/icon-why-choose-1.svg" alt="">
                            </div>
                            <div class="why-choose-item-content">
                                <h3>Emergency Services</h3>
                                <p>We provide prompt and reliable emergency care for infants and children to address urgent health concerns when you need it most.</p>
                            </div>
                        </div>
                        <!-- Why Choose Item End -->

                        <!-- Why Choose Item Start -->
                        <div class="why-choose-item wow fadeInUp" data-wow-delay="0.25s">
                            <div class="icon-box">
                                <img src="images/icon-why-choose-2.svg" alt="">
                            </div>
                            <div class="why-choose-item-content">
                                <h3>positive patient reviews</h3>
                                <p>Our clinic is trusted by hundreds of happy patients who appreciate our compassionate care and expert treatment</p>
                            </div>
                        </div>
                        <!-- Why Choose Item End -->

                        <!-- Why Choose Item Start -->
                        <div class="why-choose-item wow fadeInUp" data-wow-delay="0.5s">
                            <div class="icon-box">
                                <img src="images/icon-why-choose-3.svg" alt="">
                            </div>
                            <div class="why-choose-item-content">
                                <h3>experienced professionals</h3>
                                <p>Our team of skilled and experienced pediatricians and neonatologists is dedicated to delivering the highest standard of care for infants and children.</p>
                            </div>
                        </div>
                        <!-- Why Choose Item End -->
                    </div>
                    <!-- Why Choose List End -->
                </div>
            </div>
        </div>
    </div>
    <!-- Why Choose Us Section End -->

    <!-- Our Testimonial Section Start -->
    <div class="our-testimonials" id="testimonials">
        <div class="container">
            <div class="row section-row align-items-center">
                <div class="col-lg-8">
                    <!-- Section Title Start -->
                    <div class="section-title">
                        <h3 class="wow fadeInUp">testimonial</h3>
                        <h2 class="text-anime-style-3" data-cursor="-opaque">Real stories of expert care and joyful childhood moments.</h2>
                    </div>
                    <!-- Section Title End -->
                </div>

                <div class="col-lg-4">
                    <!-- Section Btn Start -->
                    <div class="section-btn wow fadeInUp">
                        <a href="contact-us.php" class="btn-default btn-border">contact us now</a>
                    </div>
                    <!-- Section Btn End -->
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12">
                    <!-- Testimonial Slider Start -->
					<div class="testimonial-slider">
						<div class="swiper">
							<div class="swiper-wrapper">
								<!-- Testimonial Slide Start -->
								<div class="swiper-slide">
									<div class="testimonial-item">	
                                        <div class="testimonial-header">
                                            <div class="testimonial-quote">
                                                <img src="images/icon-quote.svg" alt="">
                                            </div>
                                            <div class="testimonial-content">
                                                <p>
                                                    Dr. Santosh Mane is an excellent pediatrician! He is very knowledgeable, patient, and caring. He listens carefully to all concerns and provides clear explanations and the best treatment for children. His kind and friendly approach makes both parents and kids feel comfortable. He is also very responsive, even beyond clinic hours, which is truly reassuring. I highly recommend him to anyone looking for a great child specialist in Dhanori!
                                                </p>									
                                            </div>
                                        </div>
                                        <div class="testimonial-body">
                                            <div class="author-image">
                                                <figure class="image-anime">
                                                    <img src="images/ragini.png" alt="">
                                                </figure>
                                            </div>            
                                            <div class="author-content">
                                                <h3>Ragini Kaushal</h3>
                                                <!-- <p>co. founder</p> -->
                                            </div>
                                        </div>													
									</div>
								</div>
								<!-- Testimonial Slide End -->

                                <!-- Testimonial Slide Start -->
								<div class="swiper-slide">
									<div class="testimonial-item">	
                                        <div class="testimonial-header">
                                            <div class="testimonial-quote">
                                                <img src="images/icon-quote.svg" alt="">
                                            </div>
                                            <div class="testimonial-content">
                                                <p>
                                                    I have been visiting Dr Mane since last one and half year for my younger daughter. He has been spot on for diagnosing the problem. He doesn't believe in giving antibiotics unless absolutely necessary. He has been more than willing to entertain even at short notice. He also believes in following up the child's condition on his own which is quite different from other doctors. He is very polite and caring. Best is my daughter has got no problems in visiting him.
                                                </p>									
                                            </div>
                                        </div>
                                        <div class="testimonial-body">
                                            <div class="author-image">
                                                <figure class="image-anime">
                                                    <img src="images/atul.png" alt="">
                                                </figure>
                                            </div>            
                                            <div class="author-content">
                                                <h3>Atul Anand</h3>
                                                <!-- <p>co. founder</p> -->
                                            </div>
                                        </div>													
									</div>
								</div>
								<!-- Testimonial Slide End -->

                                <!-- Testimonial Slide Start -->
								<div class="swiper-slide">
									<div class="testimonial-item">	
                                        <div class="testimonial-header">
                                            <div class="testimonial-quote">
                                                <img src="images/icon-quote.svg" alt="">
                                            </div>
                                            <div class="testimonial-content">
                                                <p>Dr. Mane is always accessible and always replies on time. Takes calls by himself whenever needed..We have never had any issues getting my baby in when we need to see him and have always felt very confident in his care. He acknowledges al your queries, wont hurry up just to finish ur appointment.. I highly recommend him to anyone looking for a pediatrician.</p>									
                                            </div>
                                        </div>
                                        <div class="testimonial-body">
                                            <div class="author-image">
                                                <figure class="image-anime">
                                                    <img src="images/vrushali.png" alt="">
                                                </figure>
                                            </div>            
                                            <div class="author-content">
                                                <h3>Vrushali Patil</h3>
                                                <!-- <p>co. founder</p> -->
                                            </div>
                                        </div>													
									</div>
								</div>
								<!-- Testimonial Slide End -->
							</div>
							<div class="testimonial-btn">
                                <div class="testimonial-button-prev"></div>
				                <div class="testimonial-button-next"></div>
                            </div>
						</div>
					</div>
					<!-- Testimonial Slider End -->
                </div>
            </div>
        </div>
    </div>
    <!-- Our Testimonial Section End -->

    <!-- Page Panel Doctor End -->

    <!-- Our Faqs Section Start -->
    <div class="our-faqs">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <!-- Our Faqs Content Start -->
                    <div class="our-faqs-content">
                        <!-- Section Title Start -->
                        <div class="section-title">
                            <h3 class="wow fadeInUp">FAQs</h3>
                            <h2 class="text-anime-style-2" data-cursor="-opaque">Everything You Need to Know About Pediatricians & Neonatologists</h2>
                            <p class="wow fadeInUp" data-wow-delay="0.25s">Find quick answers to common questions about our pediatric services, procedures, and patient care in our FAQ section.</p>
                        </div>
                        <!-- Section Title End -->

                        <!-- Section CTA Box Start -->
                        <div class="section-cta-box wow fadeInUp" data-wow-delay="0.5s">
                            <div class="icon-box">
                                <img src="images/icon-faqs-cta-box.svg" alt="">
                            </div>
                            <div class="section-cta-content">
                                <p>Where tiny smiles grow into healthy futures.</p>
                                <h3>Call us on</h3>
                                <span>+91 99224 46723</span>
                            </div>
                        </div>
                        <!-- Section CTA Box End -->
                    </div>  
                    <!-- Our Faqs Content End -->                  
                </div>

                <div class="col-lg-6">
                    <div class="our-faq-section">
                        <!-- FAQ Accordion Start -->
                        <div class="faq-accordion" id="faqaccordion">
                            <!-- FAQ Item Start -->
                            <div class="accordion-item wow fadeInUp">
                                <h2 class="accordion-header" id="heading1">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse1" aria-expanded="true" aria-controls="collapse1">
                                       When should I take my newborn to see a Pediatrician?
                                    </button>
                                </h2>
                                <div id="collapse1" class="accordion-collapse collapse" aria-labelledby="heading1" data-bs-parent="#faqaccordion">
                                    <div class="accordion-body">
                                        <p>It’s recommended to visit your Pediatrician within the first week after birth (usually 3–5 days old) to check your baby’s weight, feeding, and overall health. After that, follow the regular vaccination and growth monitoring schedule as advised by your doctor.</p>
                                    </div>
                                </div>
                            </div>
                            <!-- FAQ Item End -->

                            <!-- FAQ Item Start -->
                            <div class="accordion-item wow fadeInUp" data-wow-delay="0.2s">
                                <h2 class="accordion-header" id="heading2">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse2" aria-expanded="false" aria-controls="collapse2">
                                        What should I do if my baby has a fever?
                                    </button>
                                </h2>
                                <div id="collapse2" class="accordion-collapse collapse" aria-labelledby="heading2" data-bs-parent="#faqaccordion">
                                    <div class="accordion-body">
                                        <p>If your baby under 3 months has a fever (temperature above 100.4°F / 38°C), you should see a doctor immediately. For older infants and children, monitor their temperature, keep them hydrated, and seek medical attention if the fever persists beyond 2–3 days or is accompanied by other symptoms like irritability, poor feeding, or difficulty breathing.</p>
                                    </div>
                                </div>
                            </div>
                            <!-- FAQ Item End -->

                            <!-- FAQ Item Start -->
                            <div class="accordion-item wow fadeInUp" data-wow-delay="0.4s">
                                <h2 class="accordion-header" id="heading3">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse3" aria-expanded="false" aria-controls="collapse3">
                                      How can I ensure my child’s proper growth and development?
                                    </button>
                                </h2>
                                <div id="collapse3" class="accordion-collapse collapse show" aria-labelledby="heading3" data-bs-parent="#faqaccordion">
                                    <div class="accordion-body">
                                        <p>Regular check-ups with your Pediatrician help track your child’s growth, nutrition, and developmental milestones. Ensure your child gets a balanced diet, adequate sleep, timely vaccinations, and plenty of playtime for physical and mental development.</p>
                                    </div>
                                </div>
                            </div>
                            <!-- FAQ Item End -->    

                            <!-- FAQ Item Start -->
                            <div class="accordion-item wow fadeInUp" data-wow-delay="0.6s">
                                <h2 class="accordion-header" id="heading4">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse4" aria-expanded="false" aria-controls="collapse4">
                                        What conditions does a Neonatologist treat?
                                    </button>
                                </h2>
                                <div id="collapse4" class="accordion-collapse collapse" aria-labelledby="heading4" data-bs-parent="#faqaccordion">
                                    <div class="accordion-body">
                                        <p>A Neonatologist treats newborns with conditions such as premature birth, low birth weight, breathing difficulties, infections, birth asphyxia, and congenital anomalies. They also manage babies in the Neonatal Intensive Care Unit (NICU) who need special monitoring or support.</p>
                                    </div>
                                </div>
                            </div>
                            <!-- FAQ Item End --> 
                         </div>
                        <!-- FAQ Accordion End -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Our Faqs Section End -->
	
	<!-- Photo Gallery Section Start -->
	<div class="our-gallery-page">
		<div class="container">
		
		<div class="row section-row align-items-center">
                <div class="col-lg-8">
                    <!-- Section Title Start -->
                    <div class="section-title">
                        <h3 class="wow fadeInUp">Photo Gallery</h3>
                        <h2 class="text-anime-style-3" data-cursor="-opaque">Pediatric, transformations, and clinic moments.</h2>
                    </div>
                    <!-- Section Title End -->
                </div>

                <div class="col-lg-4">
                   
                </div>
            </div>
			<!-- gallery section start -->
			<div class="row gallery-items">
                <div class="col-lg-4 col-md-6 col-6">
                    <!-- image gallery start -->
                    <div class="photo-gallery wow fadeInUp" data-cursor-text="View">
                        <a href="images/gallery/gallery1.jpg">
                            <figure>
                                <img src="images/gallery/gallery1.jpg" alt="">
                            </figure>
                        </a>
                    </div>
                    <!-- image gallery end -->
                </div>

                <div class="col-lg-4 col-md-6 col-6">
                    <!-- image gallery start -->
                    <div class="photo-gallery wow fadeInUp" data-wow-delay="0.2s" data-cursor-text="View">
                        <a href="images/gallery/gallery2.jpg">
                            <figure>
                                <img src="images/gallery/gallery2.jpg" alt="">
                            </figure>
                        </a>
                    </div>
                    <!-- image gallery end -->
                </div>

                <div class="col-lg-4 col-md-6 col-6">
                    <!-- image gallery start -->
                    <div class="photo-gallery wow fadeInUp" data-wow-delay="0.4s" data-cursor-text="View">
                        <a href="images/gallery/gallery3.jpg">
                            <figure>
                                <img src="images/gallery/gallery3.jpg" alt="">
                            </figure>
                        </a>
                    </div>
                    <!-- image gallery end -->
                </div>

                <div class="col-lg-4 col-md-6 col-6">
                    <!-- image gallery start -->
                    <div class="photo-gallery wow fadeInUp" data-wow-delay="0.6s" data-cursor-text="View">
                        <a href="images/gallery/gallery4.jpg">
                            <figure>
                                <img src="images/gallery/gallery4.jpg" alt="">
                            </figure>
                        </a>
                    </div>
                    <!-- image gallery end -->
                </div>

                <div class="col-lg-4 col-md-6 col-6">
                    <!-- image gallery start -->
                    <div class="photo-gallery wow fadeInUp" data-wow-delay="0.8s" data-cursor-text="View">
                        <a href="images/gallery/gallery5.jpg">
                            <figure>
                                <img src="images/gallery/gallery5.jpg" alt="">
                            </figure>
                        </a>
                    </div>
                    <!-- image gallery end -->
                </div>

                <div class="col-lg-4 col-md-6 col-6">
                    <!-- image gallery start -->
                    <div class="photo-gallery wow fadeInUp" data-wow-delay="1s" data-cursor-text="View">
                        <a href="images/gallery/gallery7.jpg">
                            <figure>
                                <img src="images/gallery/gallery7.jpg" alt="">
                            </figure>
                        </a>
                    </div>
                    <!-- image gallery end -->
                </div>
                
                
			</div>
			<!-- gallery section end -->
		</div>
	</div>
	<!-- Photo Gallery Section End -->

    <!-- Book Appointment Section Start -->
    <div class="book-appointment" id="contact">
        <div class="container">
            <div class="row section-row align-items-center">
                <div class="col-lg-6">
                    <!-- Section Title Start -->
                    <div class="section-title">
                        <h3 class="wow fadeInUp">Book Your Appointment</h3>
                        <h2 class="text-anime-style-3" data-cursor="-opaque">Book your appointment with Cloud Pediatrician & Neonatologist</h2>
                    </div>
                    <!-- Section Title End -->
                </div>
    
                <div class="col-lg-6">
                    <!-- Section Btn Start -->
                    <div class="section-title-content wow fadeInUp" data-wow-delay="0.25s">
                        <p class="wow fadeInUp">Ready to take the next step towards better health for your little one?
                         Use our easy online booking system to schedule your appointment with our Pediatrician & Neonatologist. Simply select a convenient date and time, provide some basic information, and we'll handle the rest.</p>
                    </div>
                    <!-- Section Btn End -->
                </div>
            </div>

            <div class="row">
                <div class="col-lg-5">
                    <!-- Book Appointment Sidebar Start -->
                    <div class="book-appointment-sidebar">
                        <!-- Working Time Box Start -->
                        <div class="working-time-box wow fadeInUp">
                            <!-- Working Box Title Start -->
                            <div class="working-box-title">
                                <h3>Working Hours</h3>
                            </div>
                            <!-- Working Box Title End -->
                             <h5 style="color: #ffffff;font-size: 18px;padding-bottom: 20px;">Porwal Road Clinic</h5>
                            <!-- Working Time List Start -->
                            <div class="working-time-list">
                                <ul>
                                    <li><span>Monday To Saturday </span>10am - 1pm & 6pm - 9pm</li>
                                    <!-- <li><span>Saturday </span>9am - 4pm</li> -->
                                    <li><span>Sunday </span>Open (By Appointment)</li>
                                </ul>
                            </div><br>
                            <hr style="color: #ffffff;">
                            <!-- Working Time List End -->
                             <h5 style="color: #ffffff;font-size: 18px;padding-bottom: 20px;">Tingre Nagar Clinic</h5>
                            <!-- Working Time List Start -->
                            <div class="working-time-list">
                                <ul>
                                    <li><span>Monday To Saturday </span>9am - 10am & 1pm - 2pm</li>
                                    <li><span>Monday To Saturday </span>5pm - 6am & 9pm - 10pm</li>
                                    <li><span>Sunday </span>Open(By Appointment)</li>
                                </ul>
                            </div>
                            <!-- Working Time List End -->
                        </div>
                        <!-- Working Time Box End -->
						
                    </div>
                    <!-- Book Appointment Sidebar End -->
                </div>

                <div class="col-lg-7">
                    <!-- Appointment Form Start -->
                    <div class="appointment-form wow fadeInUp" data-wow-delay="0.25s">
                        <div class="appointment-form-content">
                            <p>Fill out the form below to request your pediatric appointment. We'll confirm your time and send you a reminder.</p>
                        </div>
                        <!-- Form Start -->
                        <form id="appointmentForm" action="#" method="POST" data-toggle="validator">
                            <div class="row">
                                <div class="form-group col-md-6 mb-4">
                                    <input type="text" name="name" class="form-control" id="name" placeholder="Enter Your Name" required>
                                    <div class="help-block with-errors"></div>
                                </div>

                                <div class="form-group col-md-6 mb-4">
                                    <input type="email" name ="email" class="form-control" id="email" placeholder="Enter Your Email" required>
                                    <div class="help-block with-errors"></div>
                                </div>


                                <div class="form-group col-md-6 mb-4">
                                    <input type="date" name="date" class="form-control" id="date" required>
                                    <div class="help-block with-errors"></div>
                                </div>

                                <div class="form-group col-md-6 mb-4">
                                    <input type="time" name="time" class="form-control" id="time" required>
                                    <div class="help-block with-errors"></div>
                                </div>

                                <div class="appointment-form-title">
                                    <h3>Reason For Visit</h3>
                                </div>

                                <div class="appointment-reason">
                                    <div class="reason-box">
                                        <input type="radio" id="routine" name="reason" value="Routine Checkup" checked>
                                        <label for="routine">Routine Checkup</label>
                                    </div>                                      
                                    <div class="reason-box">
                                        <input type="radio" id="new" name="reason" value="New Patient Visit">
                                        <label for="new">New Patient Visit</label>
                                    </div>
                                   
                                </div>

                                <div class="col-md-12">
                                    <button type="submit" class="btn-default">book appointment</button>
                                    <div id="msgSubmit" class="h3 hidden"></div>
                                </div>
                            </div>
                        </form>
                        <!-- Form End -->
                    </div>
                    <!-- Appointment Form End -->
                </div>
            </div>
        </div>
    </div>
    <!-- Book Appointment Section End -->


	<!-- Google Map starts -->
    <div class="google-map">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Google Map Iframe Start -->
                    <div class="google-map-iframe">
					   <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3781.8587356827825!2d73.8961356!3d18.580406399999998!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3bc2c7af23490041%3A0xcc2cbab42f990814!2sDr%20Santosh%20Mane%20-%20Child%20Specialist%20in%20Viman%20nagar%20%7C%20Pediatrician%20%7CChild%20Clinic%20%26%20vaccination%20in%20Vishrantwadi%20Tingre%20Nagar!5e0!3m2!1sen!2sin!4v1761305418581!5m2!1sen!2sin" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                    <!-- Google Map Iframe End -->
                </div>
            </div>
        </div>
    </div>
    <!-- Google Map Ends -->
</div>

<!-- Footer Start -->
	<?php include 'footer.php';?>
<!-- Footer End -->
  

    <!-- Jquery Library File -->
    <script src="js/jquery-3.7.1.min.js"></script>
    <!-- Bootstrap js file -->
    <script src="js/bootstrap.min.js"></script>
    <!-- Validator js file -->
    <script src="js/validator.min.js"></script>
    <!-- SlickNav js file -->
    <script src="js/jquery.slicknav.js"></script>
    <!-- Swiper js file -->
    <script src="js/swiper-bundle.min.js"></script>
    <!-- Counter js file -->
    <script src="js/jquery.waypoints.min.js"></script>
    <script src="js/jquery.counterup.min.js"></script>
    <!-- Magnific js file -->
    <script src="js/jquery.magnific-popup.min.js"></script>
    <!-- SmoothScroll -->
    <script src="js/SmoothScroll.js"></script>
    <!-- Parallax js -->
    <script src="js/parallaxie.js"></script>
	<!-- Image Comparision js -->
    <script src="js/jquery.event.move.js"></script>
	<script src="js/jquery.twentytwenty.js"></script>
    <!-- MagicCursor js file -->
    <script src="js/gsap.min.js"></script>
    <script src="js/magiccursor.js"></script>
    <!-- Text Effect js file -->
    <script src="js/SplitText.js"></script>
    <script src="js/ScrollTrigger.min.js"></script>
    <!-- YTPlayer js File -->
    <script src="js/jquery.mb.YTPlayer.min.js"></script>
    <!-- Wow js file -->
    <script src="js/wow.js"></script>
    <!-- Main Custom js file -->
    <script src="js/function.js"></script>
	<script src="assets/js/theme-panel.html"></script>
</body>
</html>