
  function initAppointmentOverlay() {
    const apptOverlay = document.getElementById('appointment-overlay');
    if (!apptOverlay) return;

    const openApptBtns = document.querySelectorAll('.open-appointment');
    const closeApptBtn = apptOverlay.querySelector('.appt-close-btn');
    const backdrop     = apptOverlay.querySelector('.appt-overlay-backdrop');

    openApptBtns.forEach(btn => {
      btn.addEventListener('click', function (e) {
        e.preventDefault();
        apptOverlay.classList.add('show');
        window.scrollTo({ top: 0, behavior: 'smooth' });
      });
    });

    function closeAppt() {
      apptOverlay.classList.remove('show');
    }

    if (closeApptBtn) closeApptBtn.addEventListener('click', closeAppt);
    if (backdrop)     backdrop.addEventListener('click', closeAppt);
  }

  // load navbar, then init overlay
  fetch("navbar.html")
    .then(r => r.text())
    .then(html => {
      document.getElementById("navbar-placeholder").innerHTML = html;
      initAppointmentOverlay();              // important line
    })
    .catch(err => console.error("Navbar load error:", err));
